


cap program drop calculate_size_quantiles
program define calculate_size_quantiles

use $sources/Persons/PsnID_NbrApp.dta, clear
qui su nbr_app, d 
gen p90 = `r(p90)'
gquantiles pctile = nbr_app, pctile nq(1000)
gen p999 = pctile[999]
gen p998 = pctile[998]
gen p995 = pctile[995]
drop pctile
gquantiles pctile = nbr_app, pctile nq(10000)
gen p9999 = pctile[9999]
drop pctile
keep if _n == 1
keep p*
drop psn_id
save $sources/Persons/ListPercentilesPSNsize.dta, replace

end


capture mkdir $data/MicroTest


/*______________________________________________________________________
------------------------------------------------------------------------

DEFINE THE PROGRAM: build_year_files
This program creates a number of intermediary files useful for the test of network diffusion, on the sample of randomly selected applicants for the initialization year (iy) set as a parameter.

________________________________________________________________________*/

cap program drop build_year_files
program define build_year_files
syntax, iy(integer)

*local iy 2000

use if year(priority_date) == `iy' using $sources/Dates/App_Dates, clear // only applications after `year'
merge m:1 appln_id using $sources/Applications/App_AdministrativeInfo.dta, nogen keep(3) keepusing(appln_office)
keep if appln_office == 187 // keep only USPTO applications
keep appln_id
gduplicates drop
merge 1:m appln_id using $sources/Applications/AppPsnID_OnlyAssignee, nogen keep(3)
keep psn_id
gduplicates drop
save "$data/MicroTest/ListPSN`iy'_USPTO.dta", replace
	
use if year(priority_date) > `iy' using $sources/Dates/App_Dates, clear // only applications after `year'
merge m:1 appln_id using $sources/Applications/App_AdministrativeInfo.dta, nogen keep(3) keepusing(appln_office)
keep if appln_office == 187 // keep only USPTO applications
keep appln_id
gduplicates drop
merge 1:m appln_id using $sources/Applications/AppPsnID_OnlyAssignee, nogen keep(3)
keep psn_id
joinby psn_id using $sources/Persons/PsnID_OnlyAssignee.dta
gduplicates drop
save "$data/MicroTest/ListPSNpost`iy'_USPTO.dta", replace

use $data/MicroTest/ListPSN`iy'_USPTO.dta, clear
joinby psn_id using $data/MicroTest/ListPSNpost`iy'_USPTO.dta
joinby psn_id using $sources/Persons/PSN_Type.dta
keep if psn_type == 1
drop psn_type
sample $sampling
save "$data/MicroTest/Opsn_IY`iy'_USPTO.dta", replace


*use $data/ListRDMPSNFirms.dta, clear
use "$data/MicroTest/Opsn_IY`iy'_USPTO.dta", clear
merge 1:m psn_id using $sources/Applications/AppPsnID_OnlyFirms.dta, nogen keep(3)
keep appln_id psn_id
merge m:1 appln_id using $sources/Applications/App_AdministrativeInfo.dta, nogen keep(3) keepusing(appln_office)
keep if appln_office == 187
drop appln_office
bysort psn_id appln_id : keep if _n==1
compress
label data "Random sample for initialization year `iy', firms and patents"
save "$data/MicroTest/Opsn-Oapp_USPTO_IY`iy'.dta", replace


cd $sources/Dates
cap unzipfile App_Dates

use $data/MicroTest/Opsn-Oapp_USPTO_IY`iy'.dta, clear
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3)
gen year = year(priority_date)
keep if year > `iy'
keep psn_id appln_id
compress
label data "Random sample, firms and patents post `iy'"
save $data/MicroTest/Opsn-Oapp_Post`iy'_USPTO_IY`iy'.dta, replace
keep psn_id
bysort psn_id : keep if _n==1
label data "Random sample, firms with patents post `iy'"
save "$data/MicroTest/Opsn_Post`iy'_USPTO_IY`iy'.dta", replace

use $data/MicroTest/Opsn-Oapp_USPTO_IY`iy'.dta, clear
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3)
gen year = year(priority_date)
keep if year == `iy'
keep psn_id appln_id
compress
label data "Random sample, firms and patents in `iy'"
save $data/MicroTest/Opsn-Oapp_Only`iy'_USPTO_IY`iy'.dta, replace
keep psn_id
bysort psn_id : keep if _n==1
label data "Random sample, firms with patents in `iy'"
save $data/MicroTest/Opsn_Only`iy'_USPTO_IY`iy'.dta, replace

*Citations of the rdm sample
*******************/

cd $sources/Applications
capture unzipfile App_AdministrativeInfo
cd $sources/Citations
capture unzipfile ODapp_Citations_NSC
use $data/MicroTest/Opsn-Oapp_USPTO_IY`iy'.dta, clear
bysort appln_id : keep if _n==1
ren appln_id o_appln_id
merge 1:m o_appln_id using $sources/Citations/ODapp_Citations_NSC.dta, nogen keep(3)
keep o_appln_id d_appln_id
bysort o_appln_id d_appln_id : keep if _n==1
ren d_appln_id appln_id
merge m:1 appln_id using $sources/Applications/App_AdministrativeInfo.dta, nogen keep(3) keepusing(appln_office)
keep if appln_office == 187
drop appln_office
ren appln_id d_appln_id
merge 1:1 o_appln_id d_appln using $sources/Citations/ODapp_Citations_OnlyAA.dta, keep(1 3)
gen AA = (_merge==3)
drop _merge
merge 1:1 o_appln_id d_appln using $sources/Citations/ODapp_Citations_OnlyEA.dta, keep(1 3)
gen EA = (_merge==3)
drop _merge
compress
label data "Citations of the random sample, only USPTO for O and D"
save $data/MicroTest/ODapp_USPTO_IY`iy'.dta, replace
keep if AA == 1
label data "AA Citations of the random sample, only USPTO for O and D"
save $data/MicroTest/ODapp_AA_USPTO_IY`iy'.dta, replace

use if EA == 1 using $data/MicroTest/ODapp_USPTO_IY`iy'.dta, clear
label data "EA Citations of the random sample, only USPTO for O and D"
save $data/MicroTest/ODapp_EA_USPTO_IY`iy'.dta, replace


use $data/MicroTest/Opsn-Oapp_Post`iy'_USPTO_IY`iy'.dta, clear
bysort appln_id : keep if _n==1
ren appln_id o_appln_id
merge 1:m o_appln_id using $sources/Citations/ODapp_Citations_NSC.dta, nogen keep(3)
keep o_appln_id d_appln_id
bysort o_appln_id d_appln_id : keep if _n==1
ren d_appln_id appln_id
merge m:1 appln_id using $sources/Applications/App_AdministrativeInfo.dta, nogen keep(3) keepusing(appln_office)
keep if appln_office == 187
drop appln_office
ren appln_id d_appln_id
merge 1:1 o_appln_id d_appln using $sources/Citations/ODapp_Citations_OnlyAA.dta, keep(1 3)
gen AA = (_merge==3)
drop _merge
merge 1:1 o_appln_id d_appln using $sources/Citations/ODapp_Citations_OnlyEA.dta, keep(1 3)
gen EA = (_merge==3)
drop _merge
compress
label data "Citations of the random sample, post `iy', only USPTO for O and D"
save $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, replace

use $data/MicroTest/ODapp_USPTO_IY`iy'.dta, clear
ren o_appln_id appln_id
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
gen year = year(priority_date)
keep if year == `iy'
drop priority_date year
ren appln_id o_appln_id
compress
label data "Citations of the random sample, only `iy', only USPTO for O and D"
save $data/MicroTest/ODapp_Only`iy'_USPTO_IY`iy'.dta, replace


use $data/MicroTest/ODapp_USPTO_IY`iy'.dta, clear
keep d_appln_id
ren d_appln_id appln_id
bysort appln_id : keep if _n==1
*Only applicant are valid cited firms
merge 1:m appln_id using $sources/Applications/AppPsnID_OnlyAssignee.dta, nogen keep(3)
bysort appln_id psn_id : keep if _n==1
label data "Cited patents and their PSN, only assignee and USPTO"
compress
save $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta, replace

use $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta, clear
keep psn_id
bysort psn_id : keep if _n==1
label data "PSN -- Only cited at least once by the random sample"
compress
save $data/MicroTest/Dpsn_USPTO_IY`iy'.dta, replace

use $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
keep d_appln_id
ren d_appln_id appln_id
bysort appln_id : keep if _n==1
*Only applicant are valid cited firms
merge 1:m appln_id using $sources/Applications/AppPsnID_OnlyAssignee.dta, nogen keep(3)
bysort appln_id psn_id : keep if _n==1
label data "Cited patents and their PSN, only assignee and USPTO"
compress
save $data/MicroTest/Dapp-Dpsn_CitedPost`iy'_USPTO_IY`iy'.dta, replace

use $data/MicroTest/Dapp-Dpsn_CitedPost`iy'_USPTO_IY`iy'.dta, clear
keep psn_id
bysort psn_id : keep if _n==1
label data "PSN -- Only cited at least once by the random sample"
compress
save $data/MicroTest/Dpsn_CitedPost`iy'_USPTO_IY`iy'.dta, replace

use $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta, clear
keep appln_id
bysort appln_id : keep if _n==1
label data "App -- Only cited at least once by the random sample"
compress
save $data/MicroTest/Dapp_USPTO_IY`iy'.dta, replace

use $data/MicroTest/Dapp-Dpsn_CitedPost`iy'_USPTO_IY`iy'.dta, clear
keep appln_id
bysort appln_id : keep if _n==1
label data "App -- Only cited at least once by the random sample after `iy'"
compress
save $data/MicroTest/Dapp_CitedPost`iy'_USPTO_IY`iy'.dta, replace


*First year of citation of patent d by firm o
*******************/

use $data/MicroTest/Opsn-Oapp_USPTO_IY`iy'.dta, clear
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
gen year = year(priority_date)
keep psn_id appln_id year
ren appln_id o_appln_id
joinby o_appln_id using $data/MicroTest/ODapp_USPTO_IY`iy'.dta
ren psn_id o_psn_id
replace AA = . if AA==0
gen year_AA = year*AA
collapse (min) app_fyc=year app_fyc_AA=year_AA, by(o_psn_id d_appln_id)
label var app_fyc "First year of citation of patent d by firm o"
label var app_fyc_AA "First year of AA citation of patent d by firm o"
label data "Opsn - Dapp -- First year of citation"
save $data/MicroTest/Opsn-Dapp_FYC_IY`iy', replace


use $data/MicroTest/Opsn-Oapp_USPTO_IY`iy'.dta, clear
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3)
gen year = year(priority_date)
keep psn_id appln_id year
ren appln_id o_appln_id
ren psn_id o_psn_id
joinby o_appln_id using $data/MicroTest/ODapp_USPTO_IY`iy'.dta
ren d_appln_id appln_id
joinby appln_id using $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta
ren appln_id d_appln_id
ren psn_id d_psn_id
replace AA = . if AA==0
gen year_AA = year*AA
collapse (min) psn_fyc=year psn_fyc_AA=year_AA, by(o_psn_id d_psn_id)
label var psn_fyc "First year of citation of d_firm by o_firm"
label var psn_fyc_AA "First year of AA citation of d_firm by o_firm"
compress
label data "ODpsn -- First year of citation"
save $data/MicroTest/ODpsn_FYC_IY`iy', replace
/*

*Drop the o_appln_id that do not have at least one AA and one EA (to be consistent with conditionnal logit sample
use $data/MicroTest/ODapp_USPTO_IY`iy'.dta, clear
collapse (max) AA EA, by(o_appln_id)
keep if AA == 1 & EA == 1
keep o_appln_id
label data "Oapp -- Only with at least one outward AA and EA cit"
save $data/MicroTest/Oapp_OnlyBothAAandEA_IY`iy'.dta, replace

use $data/MicroTest/ODapp_USPTO_IY`iy'.dta, clear
replace EA = 0 if AA == 1
collapse (max) AA EA, by(o_appln_id)
keep if AA == 1 & EA == 1
keep o_appln_id
label data "Oapp -- Only with at least one outward AA and EA cit, mutually exclusive AA-EA"
save $data/MicroTest/Oapp_OnlyBothAAandEA_ME_IY`iy'.dta, replace
*/


*Info on the size of the largest PSN (O and D)
cd $sources/Persons
cap unzipfile PsnID_NbrApp
use $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
ren d_appln_id appln_id
joinby appln_id using $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta
merge m:1 psn_id using $sources/Persons/PsnID_NbrApp.dta, nogen keep(3)
ren appln_id d_appln_id
collapse (max) nbr_app, by(o_appln_id d_appln_id)
ren nbr_app d_psn_nbr_app
label var d_psn_nbr_app "Number of patents of the largest assignee of d_appln"
ren o_appln_id appln_id
joinby appln_id using $data/MicroTest/Opsn-Oapp_USPTO_IY`iy'.dta
merge m:1 psn_id using $sources/Persons/PsnID_NbrApp.dta, nogen keep(3)
ren appln_id o_appln_id
collapse (max) d_psn_nbr_app nbr_app, by(o_appln_id d_appln_id)
ren nbr_app o_psn_nbr_app
label var o_psn_nbr_app "Number of patents of the largest assignee of o_appln"
label data "ODapp -- Size of the largest applicant"
save $data/MicroTest/ODapp_PSNsize_IY`iy'.dta, replace


end


/*------------------------------------------
					END
------------------------------------------*/

********************************************************************************


/*______________________________________________________________________
------------------------------------------------------------------------

DEFINE THE PROGRAM: prepare_contacts
This program creates a number of intermediary files defining the contact of our
selected firms, their patents and their citations.
________________________________________________________________________*/


********************************************************************************
*Prepare C
********************************************************************************

capture program drop prepare_contacts
program define prepare_contacts
syntax, percentile(real) iy(integer)

*iy : initialization year 

use  $sources/Persons/ListPercentilesPSNsize.dta, clear
qui sum p`percentile'
global size_threshold = `r(mean)'

use $data/MicroTest/ODapp_Only`iy'_USPTO_IY`iy'.dta, clear
keep if AA == 1
drop AA EA
ren d_appln_id appln_id
joinby appln_id using $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta
drop appln_id
merge m:1 psn_id using $sources/Persons/PsnID_NbrApp.dta, nogen keep(3) keepusing(nbr_app)
keep if nbr_app < $size_threshold
drop nbr_app
ren psn_id c_psn_id
label var c_psn_id "Contact PSN"
bysort o_appln_id c_psn_id : keep if _n==1
compress
label data "o_appln_id and their associated contacts"
save $data/MicroTest/Oapp-Cpsn_CSP`percentile'_IY`iy'.dta, replace

**EA contacts
use if EA == 1 using $data/MicroTest/ODapp_Only`iy'_USPTO_IY`iy'.dta, clear
drop AA EA
ren d_appln_id appln_id
joinby appln_id using $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta
drop appln_id
merge m:1 psn_id using $sources/Persons/PsnID_NbrApp.dta, nogen keep(3) keepusing(nbr_app)
keep if nbr_app < $size_threshold
drop nbr_app
ren psn_id c_psn_id
label var c_psn_id "Contact PSN"
bysort o_appln_id c_psn_id : keep if _n==1
compress
label data "o_appln_id and their associated fake contacts"
save $data/MicroTest/Oapp-Cpsn_EAContacts_CSP`percentile'_IY`iy'.dta, replace

*Random firms and their contacts
use $data/MicroTest/Oapp-Cpsn_CSP`percentile'_IY`iy'.dta, clear
ren o_appln_id appln_id
joinby appln_id using $data/MicroTest/Opsn-Oapp_Only`iy'_USPTO_IY`iy'.dta
drop appln_id
order psn_id c_psn_id
bysort psn_id c_psn_id : keep if _n==1
ren psn_id o_psn_id
label data "o_psn_id and their contacts"
compress
save $data/MicroTest/Opsn-Cpsn_CSP`percentile'_IY`iy'.dta, replace

*List of contacts
use $data/MicroTest/Opsn-Cpsn_CSP`percentile'_IY`iy'.dta, clear
keep c_psn_id
bysort c_psn_id : keep if _n==1
label data "List of the contacts"
save $data/MicroTest/Cpsn_CSP`percentile'_IY`iy'.dta, replace

*Random firms and their contacts
use $data/MicroTest/Oapp-Cpsn_EAContacts_CSP`percentile'_IY`iy'.dta, clear
ren o_appln_id appln_id
joinby appln_id using $data/MicroTest/Opsn-Oapp_Only`iy'_USPTO_IY`iy'.dta
drop appln_id
order psn_id c_psn_id
bysort psn_id c_psn_id : keep if _n==1
label data "o_psn_id and their fake contacts"
compress
save $data/MicroTest/Opsn-Cpsn_EAContacts_CSP`percentile'_IY`iy'.dta, replace

*List of contacts
use $data/MicroTest/Opsn-Cpsn_EAContacts_CSP`percentile'_IY`iy'.dta, clear
keep c_psn_id
bysort c_psn_id : keep if _n==1
label data "List of the contacts"
save $data/MicroTest/Cpsn_EAContacts_CSP`percentile'_IY`iy'.dta, replace


use $data/MicroTest/Cpsn_CSP`percentile'_IY`iy'.dta, clear
ren c_psn_id psn_id
merge 1:m psn_id using $sources/Applications/AppPsnID_OnlyAssignee, nogen keep(3)
*we need ALL the patents of the contacts, not only the ones in the database, to form the CBC
merge m:1 appln_id using $sources/Applications/App_AdministrativeInfo.dta, nogen keep(3) keepusing(appln_office)
keep if appln_office == 187
drop appln_office
keep appln_id psn_id
ren appln_id c_appln_id
ren psn_id c_psn_id
bysort c_psn_id c_appln_id : keep if _n==1
compress
label data "Contacts, firms and patents"
save $data/MicroTest/Cpsn-Capp_USPTO_CSP`percentile'_IY`iy'.dta, replace


use $data/MicroTest/Opsn-Cpsn_CSP`percentile'_IY`iy'.dta, clear
joinby c_psn_id using $data/MicroTest/Cpsn-Capp_USPTO_CSP`percentile'_IY`iy'.dta
keep o_psn_id c_appln_id
duplicates drop
compress
label data "Firms and the patents of their contacts"
save $data/MicroTest/Opsn-Capp_USPTO_CSP`percentile'_IY`iy'.dta, replace

end


/*------------------------------------------
					END
------------------------------------------*/



/*______________________________________________________________________
------------------------------------------------------------------------

DEFINE THE PROGRAM: prepare_CBC
This program creates a number of intermediary files defining the contacts of contacts (CBC) of our
selected firms.
________________________________________________________________________*/


********************************************************************************
* Prepare CBC
********************************************************************************

capture program drop prepare_CBC
program define prepare_CBC
syntax, percentile(real) iy(integer)

use $data/MicroTest/Cpsn-Capp_USPTO_CSP`percentile'_IY`iy'.dta, clear
keep c_appln_id
bysort c_appln_id : keep if _n==1
ren c_appln_id o_appln_id
merge 1:m o_appln_id using $sources/Citations/ODapp_Citations_NSC.dta, nogen keep(3)
keep o_appln_id d_appln_id
ren d_appln_id appln_id
merge m:1 appln_id using $data/MicroTest/Dapp_USPTO_IY`iy'.dta, nogen keep(3)
*The CBC patent has to be a patent cited by the random sample, otherwise it's useless for our estimation.
* This makes the sample tractable.
ren appln_id d_appln_id
bysort o_appln_id d_appln_id : keep if _n==1
merge 1:1 o_appln_id d_appln using $sources/Citations/ODapp_Citations_OnlyAA.dta, keep(1 3)
gen AA = (_merge==3)
drop _merge
merge 1:1 o_appln_id d_appln using $sources/Citations/ODapp_Citations_OnlyEA.dta, keep(1 3)
gen EA = (_merge==3)
drop _merge
ren o_appln_id c_appln_id
ren d_appln_id cbc_appln_id
compress
label data "Citations of the contacts, only USPTO for O and D"
save $data/MicroTest/Capp-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta, replace

*Combine Cpsn-Capp and Capp-CBCapp to find Cpsn-CBCapp
use $data/MicroTest/Cpsn-Capp_USPTO_CSP`percentile'_IY`iy'.dta, clear
ren c_appln_id appln_id
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
gen year = year(priority_date)
ren appln_id c_appln_id
joinby c_appln_id using $data/MicroTest/Capp-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta
keep year c_psn_id cbc_appln_id AA EA
gen year_AA = .
replace year_AA = year if AA == 1
gen year_EA = .
replace year_EA = year if EA == 1
collapse (max) AA EA (min) year_AA year_EA, by(c_psn_id cbc_appln_id)
label var AA "At least one of the C AA cites cbc_app"
label var EA "At least one of the C EA cites cbc_app"
label var year_AA "First year of AA citation of cbc_app by c_psn_id"
label var year_EA "First year of EA citation of cbc_app by c_psn_id"
sort c_psn_id cbc_appln_id
compress
save $data/MicroTest/Cpsn-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta, replace


*Associate CBC app with their CBC psn
use $data/MicroTest/Capp-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta, clear
keep cbc_appln_id
ren cbc_appln_id appln_id
bysort appln_id : keep if _n==1
merge 1:m appln_id using $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta, nogen keep(3)
keep appln_id psn_id
ren appln_id cbc_appln_id
ren psn_id cbc_psn_id
bysort cbc_psn_id cbc_appln_id : keep if _n==1
compress
label data "Cited by contacts, firms and patents"
save $data/MicroTest/CBCpsn-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta, replace

*Obtain Cpsn-CBCpsn by combining Cpsn-CBCapp and CBCapp-CBCpsn
use $data/MicroTest/Cpsn-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta, clear
joinby cbc_appln_id using $data/MicroTest/CBCpsn-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta
*joinby cbc_appln_id using $data/MicroTest/CBCpsn-CBCapp_USPTO.dta
keep c_psn_id cbc_psn_id AA EA year_AA year_EA
collapse (max) AA EA (min) year_AA year_EA, by(c_psn_id cbc_psn_id)
label var AA "At least one of the C_app AA cites at least one of the CBC_psn"
label var EA "At least one of the C_app EA cites at least one of the CBC_psn"
label var year_AA "First year of AA citation of cbc_psn by c_psn"
label var year_EA "First year of EA citation of cbc_psn by c_psn"
compress
save $data/MicroTest/Cpsn-CBCpsn_USPTO_CSP`percentile'_IY`iy'.dta, replace
/*

*Obtain Opsn-CBCpsn by combining Opsn-Cpsn and Cpsn-CBCpsn
forvalues b=1/`nbr_bins'{
  di in red `b'
*/
use $data/MicroTest/Opsn-Cpsn_CSP`percentile'_IY`iy'.dta, clear
/*
local nbr_firms = _N
gen bin = ceil(_n/`nbr_firms'*`nbr_bins')
*/
joinby c_psn_id using $data/MicroTest/Cpsn-CBCpsn_USPTO_CSP`percentile'_IY`iy'.dta
*ren psn_id o_psn_id
keep o_psn_id cbc_psn_id AA EA year_AA year_EA
collapse (max) AA EA (min) year_AA year_EA, by(o_psn_id cbc_psn_id)
label var AA "At least one of the C_psn AA cites at least one of the CBC_psn"
label var EA "At least one of the C_psn EA cites at least one of the CBC_psn"
label var year_AA "First year of AA citation of cbc_psn by c_psn"
label var year_EA "First year of EA citation of cbc_psn by c_psn"
label data "Opsn and their CBCpsn"
compress
save $data/MicroTest/Opsn-CBCpsn_USPTO_CSP`percentile'_IY`iy'.dta, replace


*Obtain Opsn-CBCapp by combining Opsn-Cpsn and Cpsn-CBCpsn
use $data/MicroTest/Opsn-Cpsn_CSP`percentile'_IY`iy'.dta, clear
/*local nbr_firms = _N
gen bin = ceil(_n/`nbr_firms'*`nbr_bins')
forvalues b=1/`nbr_bins' {
	preserve
  di in red `b'
  keep if bin == `b'
*/
  joinby c_psn_id using $data/MicroTest/Cpsn-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta
  *ren psn_id o_psn_id
  keep o_psn_id cbc_appln_id AA EA year_AA year_EA
  gcollapse (max) AA EA (min) year_AA year_EA, by(o_psn_id cbc_appln_id)
  label var AA "At least one of the C_psn AA cites cbc_app"
  label var EA "At least one of the C_psn EA cites cbc_app"
  label var year_AA "First year of AA citation of cbc_app by c_psn"
  label var year_EA "First year of EA citation of cbc_app by c_psn"
  label data "Opsn and their CBCappln, bin `b'"
  compress
  save $data/MicroTest/Opsn-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta, replace
  //restore
/*


**Append the previous files
use $data/MicroTest/Opsn-CBCapp_USPTO_CSP`percentile'_IY`iy'_B1.dta, clear
forvalues b=2/`nbr_bins'{
	append using $data/MicroTest/Opsn-CBCapp_USPTO_CSP`percentile'_IY`iy'_B`b'.dta
	}
gcollapse (max) AA EA (min) year_AA year_EA, by(o_psn_id cbc_appln_id)	
label data "Opsn and their CBCappln"
compress
save $data/MicroTest/Opsn-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta, replace

forvalues b=1/`nbr_bins' {
	erase $data/MicroTest/Opsn-CBCapp_USPTO_CSP`percentile'_IY`iy'_B`b'.dta
}
*/


end


/*------------------------------------------
					END
------------------------------------------*/



/*______________________________________________________________________
------------------------------------------------------------------------

DEFINE THE PROGRAM: build_tech_dist
This program calculates Mahalanobis distances between citing and cited patents
for our selected origin firms after the initialization year (baseline is 2000).

________________________________________________________________________*/



*Maha tech dist
*******************/

cap program drop build_tech_dist
program define build_tech_dist
syntax, iy(integer)

*local iy 2000

**--


use $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
preserve
keep o_appln_id
ren o_appln_id appln_id
gduplicates drop
save "$data\MicroTest\ListO", replace
restore
keep d_appln_id
ren d_appln_id appln_id
gduplicates drop
save "$data\MicroTest\ListD", replace


use $sources/IPC/App_IPCwide_NMVcitations.dta, clear
cap drop ipc131 //many missing values
merge 1:m appln_id using "$data\MicroTest\ListO", nogen keep(3)
ds ipc*
local ipc : word 1 of `r(varlist)'
drop if mi(`ipc')
global ipc_todrop
foreach var of varlist ipc* {
	qui count if `var' == 1
	local nbr = `r(N)'
	if `r(N)' < 100 {
		global ipc_todrop $ipc_todrop `var'
	}
}
if "$ipc_todrop" != "" {
	drop $ipc_todrop
}
save "$data\MicroTest\X", replace
**
use $sources/IPC/App_IPCwide_NMVcitations.dta, clear
cap drop ipc131 //many missing values
if "$ipc_todrop" != "" {
	drop $ipc_todrop
}
global N = _N
keep if _n < $N / 2
merge 1:m appln_id using "$data\MicroTest\ListD", nogen keep(3) 
ds ipc*
local ipc : word 1 of `r(varlist)'
drop if mi(`ipc')
save "$data\MicroTest\Temp1", replace
use $sources/IPC/App_IPCwide_NMVcitations.dta, clear
cap drop ipc131 //many missing values
if "$ipc_todrop" != "" {
	drop $ipc_todrop
}
keep if _n >= $N / 2
merge 1:m appln_id using "$data\MicroTest\ListD", nogen keep(3) 
ds ipc*
local ipc : word 1 of `r(varlist)'
drop if mi(`ipc') 
append using "$data\MicroTest\Temp1"
gduplicates drop
save "$data\MicroTest\Y", replace

use *appln_id using $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
ren o_appln_id appln_id
keep appln_id d_appln_id
gduplicates drop
merge m:1 appln_id using "$data\MicroTest\X", nogen keep(3) keepusing(appln_id)
ren appln_id o_appln_id
ren d_appln_id appln_id
merge m:1 appln_id using "$data\MicroTest\Y", nogen keep(3) keepusing(appln_id)
ren appln_id d_appln_id
gduplicates drop
save "$data\MicroTest\M", replace

** Make sure X, Y and M have the same applications **
use "$data\MicroTest\M", clear
preserve
ren o_appln_id appln_id
keep appln_id
gduplicates drop
save "$data\MicroTest\ListO", replace
restore
keep d_appln_id
ren d_appln_id appln_id
gduplicates drop
save "$data\MicroTest\ListD", replace

use "$data\MicroTest\X", clear
merge 1:1 appln_id using "$data\MicroTest\ListO", nogen keep(3)
save "$data\MicroTest\X", replace

use "$data\MicroTest\Y", clear
merge 1:1 appln_id using "$data\MicroTest\ListD", nogen keep(3)
save "$data\MicroTest\Y", replace

use "$data\MicroTest\M", clear
ren o_appln_id appln_id
merge m:1 appln_id using "$data\MicroTest\X"

***--Write a R file that will use Rmahalanobis CPP package to calculate Mahalanobis distances efficiently
**--> Required: installing Rtools (from 'https://cran.r-project.org/bin/windows/Rtools/')
**--> + uncomment "install.packages" when first running the code

cap erase "$do/techdist.R"
file close _all
file open rcode using "${doR}\\techdist.R", write replace
file write rcode ///
`"install.packages("fastmatch", repos = "http://cran.us.r-project.org")"' _newline ///
`"install.packages("haven", repos = "http://cran.us.r-project.org")"' _newline ///
`"install.packages("Rcpp", repos = "http://cran.us.r-project.org")"' _newline ///
`"library(haven)"' _newline ///
`"install.packages("${doR}\\Rmahalanobis_0.1.0.zip", repos = NULL, type = "win.binary")"' _newline ///
`"library(Rmahalanobis)"' _newline ///
`"library(parallel)"' _newline ///
`"library(fastmatch)"' _newline ///
`"#sourceCpp("${doR}\\Rmahalanobis\\src\\maha_dist_c.cpp")"' _newline ///
`"data_f1 = read_dta("${dataR}\\MicroTest\\X.dta")"' _newline ///
`"data_f2 = read_dta("${dataR}\\MicroTest\\Y.dta")"' _newline ///
`"data_f3 = read_dta("${dataR}\\MicroTest\\M.dta")"' _newline ///
`"ipc <- names(data_f1)[-1]"' _newline ///
`"X = as.matrix(data_f1[ipc])"' _newline ///
`"Y = as.matrix(data_f2[ipc])"' _newline ///
`"c1 = fmatch(data_f3\$o_appln_id, data_f1\$appln_id)"' _newline ///
`"c2 = fmatch(data_f3\$d_appln_id, data_f2\$appln_id)"' _newline ///
`"M = cbind(c1, c2)"' _newline ///
`"W = solve(var(X))"' _newline ///
`"data_f3\$ipc_score <- maha_dist_c(X, Y, M, W, cores = detectCores()-1)"' _newline ///
`"write_dta(data_f3,"${dataR}\\MicroTest\\ODapp_TechMahaDist_IY`iy'.dta")"'
file close rcode

rscript using "${do}/techdist.R", rpath("C:\Program Files\R\R-4.4.1\bin\x64/Rscript.exe") //should be adapted to the local R version

end




/*______________________________________________________________________
------------------------------------------------------------------------

DEFINE THE PROGRAM: build_controls
This program builds some control variables for patents/applicants that
have already been cited by our origin firms.

________________________________________________________________________*/




cap program drop build_controls
program define build_controls
syntax, iy(integer)

/*Database with the "Already Cited" controls
*******************/


use $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
ren o_appln_id appln_id
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
gen year = year(priority_date)
drop priority_date
joinby appln_id using $data/MicroTest/Opsn-Oapp_Post`iy'_USPTO_IY`iy'.dta
ren appln_id o_appln_id
ren psn_id o_psn_id
ren d_appln_id appln_id
joinby appln_id using $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta
ren appln_id d_appln_id
ren psn_id d_psn_id
merge m:1 o_psn d_psn using $data/MicroTest/ODpsn_FYC_IY`iy', nogen keep(1 3)
gen psn_AC_before_`iy' = (year > psn_fyc & psn_fyc < `iy')
gen psn_AC_AA = (year > psn_fyc_AA & psn_fyc_AA > `iy')
gen psn_AC_EA = (year > psn_fyc & psn_fyc > `iy')
merge m:1 o_psn_id d_appln_id using $data/MicroTest/Opsn-Dapp_FYC_IY`iy', nogen keep(1 3)
gen AC_before_`iy' = (year > app_fyc & app_fyc < `iy')
gen AC_AA = (year > app_fyc_AA & app_fyc_AA > `iy')
gen AC_EA = (year > app_fyc & app_fyc > `iy')
ren o_psn_id psn_id
merge m:1 psn_id using $sources/Geography/PSN_ModCoordinates, keep(1 3)
gen o_no_coord_info = (_merge ==1)
drop _merge
ren psn_id o_psn_id
ren d_psn_id psn_id
merge m:1 psn_id using $sources/Geography/PSN_ModCoordinates, keep(1 3)
gen d_no_coord_info = (_merge ==1)
drop _merge
compress
collapse (max) psn_AC_before_`iy' psn_AC_AA psn_AC_EA AC_AA AC_EA AC_before_`iy' (min) all_psn_AC_before_`iy' = psn_AC_before_`iy' all_psn_AC_AA =  psn_AC_AA all_psn_AC_EA =  psn_AC_EA o_no_coord_info d_no_coord_info, by(o_appln_id d_appln_id)
label var AC_before_`iy' "Dapp already cited by at least one o_psn before `iy'"
label var AC_AA "d_appln already AA cited by at least one o_psn after `iy'"
label var AC_EA "d_appln already EA cited by at least one o_psn after `iy'"
label var psn_AC_before_`iy' "AL one d_psn cited by AL one o_psn before `iy'"
label var psn_AC_AA "AL one d_psn AA cited by AL one o_psn after `iy'"
label var psn_AC_EA "AL one d_psn EA cited by AL one o_psn after `iy'"
label var all_psn_AC_before_`iy' "all d_psn cited by all o_psn before `iy'"
label var all_psn_AC_AA "all d_psn AA cited by all o_psn after `iy'"
label var all_psn_AC_EA "all d_psn EA cited by all o_psn after `iy'"
compress
label data "ODapp -- Controls for already cited"
save $data/MicroTest/ODapp_ACcontrols_IY`iy'.dta, replace

*** Database with the control variables
cd $sources/Applications
cap unzipfile App_AdministrativeInfo
cap unzipfile App_Family
cd $sources/Citations
cap unzipfile App_ResNbrInwCit
cd $sources/Geography
cap unzipfile App_Coordinates_Assi
cd $sources/IPC
cap unzipfile App_IPC1d

use $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
*merge with info for origin patent
ren o_appln_id appln_id
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
merge m:1 appln_id using $sources/Geography/App_Coordinates_Assi.dta, nogen keep(1 3)
drop several_modes nbr_cities
merge m:1 appln_id using $sources/Applications/App_Family.dta, nogen keep(1 3) keepusing(inpadoc_family_id)
foreach var in appln_id priority_date mod_latitude mod_longitude m_latitude m_longitude inpadoc_family_id{
  ren `var' o_`var'
}
*merge with info for destination patent
ren d_appln_id appln_id
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
merge m:1 appln_id using $sources/Geography/App_Coordinates_Assi.dta, nogen keep(1 3)
drop several_modes nbr_cities
merge m:1 appln_id using $sources/Citations/App_ResNbrInwCit.dta, nogen keep(3)
ren res_nbr_inw_cit quality
merge m:1 appln_id using $sources/Applications/App_Family.dta, nogen keep(1 3) keepusing(inpadoc_family_id)
foreach var in appln_id priority_date mod_latitude mod_longitude m_latitude m_longitude quality inpadoc_family_id{
  ren `var' d_`var'
}
bysort o_inpadoc_family_id d_appln_id (o_priority_date) : gen AC_family =  (_n>1)
label var AC_family "Dapp already cited by at least one app of o_family"
gen age = o_priority_date - d_priority_date
drop  o_inpadoc_family_id d_inpadoc_family_id o_priority_date d_priority_date
geodist o_mod_latitude o_mod_longitude d_mod_latitude d_mod_longitude, gen(mod_distance)
geodist o_m_latitude o_m_longitude d_m_latitude d_m_longitude, gen(m_distance)
merge m:1 o_appln_id d_appln_id using $data/MicroTest/ODapp_TechMahaDist_IY`iy'.dta, nogen keep(1 3) keepusing(ipc_score)
gen tech_dist = sqrt(ipc_score)
foreach var in m_distance mod_distance tech_dist{
  replace `var' = `var' + 1
}
drop ipc_score o_mod_latitude o_mod_longitude d_mod_latitude d_mod_longitude o_m_latitude o_m_longitude d_m_latitude d_m_longitude
foreach var in m_distance mod_distance age d_quality tech_dist{
  gen ln_`var' = ln(`var')
}
bysort o_appln_id d_appln_id : keep if _n==1
merge 1:1 o_appln_id d_appln_id using $data/MicroTest/ODapp_PSNsize_IY`iy'.dta, nogen keep(3)
bysort o_appln_id d_appln_id : keep if _n==1
compress
label data "ODapp -- Control variables"
save $data/MicroTest/ODapp_ControlVariables_IY`iy'.dta, replace

end


/*------------------------------------------
					END
------------------------------------------*/




/*______________________________________________________________________
------------------------------------------------------------------------

DEFINE THE PROGRAM: prepare_reg_ready_C_and_CBC
This program builds two files, containing information on which ones of the citations made
after the initialization year by our origin firms belong to contacts (C, first file)
to patents cited by contacts (CBC, second file), or to contacts of contacts (psn_CBC, third file)

________________________________________________________________________*/




********************************************************************************
*Prepare reg ready C and CBC
********************************************************************************

capture program drop prepare_reg_ready_C_and_CBC
program define prepare_reg_ready_C_and_CBC
syntax, percentile(real) iy(integer) 

use $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
ren o_appln_id appln_id
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
gen o_year = year(priority_date)
drop priority_date
joinby appln_id using $data/MicroTest/Opsn-Oapp_Post`iy'_USPTO_IY`iy'.dta
ren appln_id o_appln_id
ren psn_id o_psn_id
ren d_appln_id appln_id
joinby appln_id using $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta
ren appln_id d_appln_id
ren psn_id d_psn_id
ren d_psn_id c_psn_id
*ren o_psn_id psn_id
merge m:1 o_psn_id c_psn_id using $data/MicroTest/Opsn-Cpsn_CSP`percentile'_IY`iy'.dta, keep(1 3)
gen C_AA = (_merge==3)
drop _merge
ren o_psn_id psn_id
merge m:1 psn_id c_psn_id using $data/MicroTest/Opsn-Cpsn_EAContacts_CSP`percentile'_IY`iy'.dta, keep(1 3)
gen C_EA = (_merge==3)
drop _merge
compress
collapse (max) C_AA C_EA (min) all_C_AA = C_AA all_C_EA = C_EA, by(o_appln_id d_appln_id)
compress
save $data/MicroTest/ODapp_C_CSP`percentile'_IY`iy'.dta, replace

/* ----- */

use $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
ren o_appln_id appln_id
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
gen o_year = year(priority_date)
drop priority_date
joinby appln_id using $data/MicroTest/Opsn-Oapp_Post`iy'_USPTO_IY`iy'.dta
ren appln_id o_appln_id
ren psn_id o_psn_id
ren d_appln_id appln_id
joinby appln_id using $data/MicroTest/Dapp-Dpsn_USPTO_IY`iy'.dta
ren appln_id d_appln_id
ren psn_id d_psn_id
ren d_psn_id cbc_psn_id
gen psn_CBC_before_`iy' = 0
gen psn_CBC_AA = 0
gen psn_CBC_EA = 0
drop AA EA
/*
forvalues b = 1/`nbr_bins' {
  di in red `b'
*/
  merge m:1 o_psn_id cbc_psn_id using $data/MicroTest/Opsn-CBCpsn_USPTO_CSP`percentile'_IY`iy'.dta, keep(1 3)
  replace psn_CBC_before_`iy' = 1 if (_merge==3 & EA == 1 & year_EA <`iy') | (_merge==3 & AA == 1 & year_AA <`iy')
  replace psn_CBC_EA = 1 if (_merge==3 & EA == 1 & year_EA < o_year) // & o_year > `iy')
  replace psn_CBC_AA = 1 if (_merge==3 & AA == 1 & year_AA < o_year) // & o_year > `iy')
  drop _merge year_AA year_EA AA EA
ren cbc_psn_id d_psn_id
compress
gcollapse (max) psn_CBC_before_`iy' psn_CBC_AA psn_CBC_EA (min) all_psn_CBC_before_`iy' = psn_CBC_before_`iy' all_psn_CBC_AA = psn_CBC_AA all_psn_CBC_EA = psn_CBC_EA, by(o_appln_id d_appln_id)
compress
save $data/MicroTest/ODapp_psnCBC_CSP`percentile'_IY`iy'.dta, replace

* AppCBC
use $data/MicroTest/ODapp_Post`iy'_USPTO_IY`iy'.dta, clear
ren o_appln_id appln_id
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
gen o_year = year(priority_date)
drop priority_date
joinby appln_id using $data/MicroTest/Opsn-Oapp_Post`iy'_USPTO_IY`iy'.dta
ren appln_id o_appln_id
ren psn_id o_psn_id
ren d_appln_id cbc_appln_id
gen byte CBC_before_`iy' = 0
gen byte CBC_AA = 0
gen byte CBC_EA = 0
drop AA EA
  merge m:1 o_psn_id cbc_appln_id using $data/MicroTest/Opsn-CBCapp_USPTO_CSP`percentile'_IY`iy'.dta, keep(1 3)
  replace CBC_before_`iy' = 1 if (_merge==3 & EA == 1 & year_EA <`iy') | (_merge==3 & AA == 1 & year_AA <`iy')
  replace CBC_EA = 1 if (_merge==3 & EA == 1 & year_EA < o_year) //  & o_year > `iy' (normalement vrai par construction)
  replace CBC_AA = 1 if (_merge==3 & AA == 1 & year_AA < o_year) //  & o_year > `iy' (normalement vrai par construction)
  drop _merge year_AA year_EA AA EA
  
ren cbc_appln_id d_appln_id
compress
gcollapse (max) CBC_before_`iy' CBC_AA CBC_EA (min) all_CBC_before_`iy' = CBC_before_`iy' all_CBC_AA = CBC_AA all_CBC_EA = CBC_EA, by(o_appln_id d_appln_id)
compress
save $data/MicroTest/ODapp_appCBC_CSP`percentile'_IY`iy'.dta, replace

end


/*------------------------------------------
					END
------------------------------------------*/



/*______________________________________________________________________
------------------------------------------------------------------------

DEFINE THE PROGRAM: build_regression_file
This program constructs the regression file for a given initialization year of contacts and a given percentile size restriction to be considered a contact.

________________________________________________________________________*/



cap program drop build_regression_file
program define build_regression_file
syntax, iy(integer) percentile(real)


*********

*** The final merge
use $data/MicroTest/ODapp_C_CSP`percentile'_IY`iy'.dta, clear
merge 1:1 o_appln_id d_appln_id using $data/MicroTest/ODapp_appCBC_CSP`percentile'_IY`iy'.dta, nogen keep(3)
merge 1:1 o_appln_id d_appln_id using $data/MicroTest/ODapp_psnCBC_CSP`percentile'_IY`iy'.dta, nogen keep(3)
compress
save $data/MicroTest/ODapp_Network_CSP`percentile'_IY`iy'.dta, replace

use $data/MicroTest/ODapp_ACcontrols_IY`iy'.dta, clear
merge 1:1 o_appln_id d_appln_id using $data/MicroTest/ODapp_ControlVariables_IY`iy'.dta, nogen keep(1 3)
merge 1:1 o_appln_id d_appln_id using $data/MicroTest/ODapp_Network_CSP`percentile'_IY`iy'.dta, nogen keep(3)
ren *before_???? *bef
ren psn_AC_bef psn_AC
ren AC_family fam_AC
replace AC_AA = 0 if AC_bef == 1
replace AC_EA = 0 if AC_bef == 1 | AC_AA == 1
replace psn_AC_AA = 0 if psn_AC == 1
replace psn_AC_EA = 0 if psn_AC == 1 | psn_AC_AA == 1
replace CBC_EA = 0 if CBC_bef == 1 | CBC_AA == 1
replace psn_CBC_EA = 0 if psn_CBC_bef == 1 | psn_CBC_AA == 1
gen byte fam_AC_ME = (fam_AC == 1 & AC_bef == 0 & AC_AA == 0)
gen byte psn_AC_ME = (psn_AC == 1 & AC_bef == 0 & AC_AA == 0 & fam_AC == 0)
gen byte psn_AC_AA_ME = (psn_AC_AA == 1 & AC_bef == 0 & AC_AA == 0 & fam_AC == 0)
gen byte psn_AC_EA_ME = (psn_AC_EA == 1 & AC_bef == 0 & AC_AA == 0 & fam_AC == 0)
ren ln_d_quality ln_quality
replace psn_AC_EA_ME = 0 if psn_AC_AA_ME == 1
compress
save $data/MicroTest/ODapp_RegReadyNetwork_CSP`percentile'_IY`iy'.dta, replace

end


/*------------------------------------------
					END
------------------------------------------*/
/*

/*______________________________________________________________________
------------------------------------------------------------------------

DEFINE THE PROGRAM: build_stacked_regression_file
This program appends several initialization year (cohort) specific regression files into one.

________________________________________________________________________*/


cap program drop build_stacked_regression_file
program define build_stacked_regression_file
syntax, iy(integer)


*********


foreach type in o d {
	local Type = upper("`type'")
	clear
	forvalues ystart = 2000/2015 {
		append using $data/MicroTest/ODapp_RegReadyNetwork_CSP99_IY`ystart', keep(`type'_appln_id)
	}
	ren `type'_appln_id appln_id
	gduplicates drop
	merge 1:m appln_id using $sources/Applications/AppPsnID_OnlyAssignee, nogen keep(3)
	bys appln_id: egen nb = nvals(psn_id)
	gen rdm = uniform()
	drop if mi(nb)
	bys appln_id (nb rdm): egen mod_`type'_psn = max(psn_id * (_n == _N))
	drop nb rdm
	keep appln_id mod_`type'_psn
	gduplicates drop
	save "$data/MicroTest/`Type'app`Type'psn_forReg", replace
}

clear
gen cohort = .
forvalues ystart = 2000/2015 {
	append using $data/MicroTest/ODapp_RegReadyNetwork_CSP99_IY`ystart'
	replace cohort = `ystart' if mi(cohort)
}
bys o_appln_id cohort: gen nb_obs = _N

desc using $data/MicroTest/ODapp_Network_CSP99_IY2000.dta, varlist
dis "`r(varlist)'"
foreach var in `r(varlist)' {
	replace `var' = 0 if mi(`var')
}

ren o_appln_id appln_id
merge m:1 appln_id using "$data/MicroTest/OappOpsn_forReg", gen(_mOpsn) keep(1 3)
merge m:1 appln_id using $sources/Dates/App_Dates.dta, nogen keep(3) keepusing(priority_date)
ren appln_id o_appln_id 
ren d_appln_id appln_id
merge m:1 appln_id using "$data/MicroTest/DappDpsn_forReg", gen(_mDpsn) keep(1 3)
ren appln_id d_appln_id 
gen o_year = year(priority_date)

reg AA C_AA CBC_AA
keep if e(sample)

gen timetotreat = o_year - cohort
replace timetotreat = 15 if timetotreat > 15 & !mi(timetotreat)

save "$data/MicroTest/ODapp_RegReadyNetwork_CSP99_Stacked", replace

end


/*------------------------------------------
					END
------------------------------------------*/
*/
