


cap program drop estimate_regsave
program define estimate_regsave
syntax, name(string) 

est save "${results}/MicroTest/`name'", replace

gdistinct mod_o_psn
local nb_psn = `r(ndistinct)'
gdistinct o_appln_id
local nb_oappln = `r(ndistinct)'
qui su AA
local mean_depvar = `r(mean)'

regsave using "${results}/MicroTest/`name'", replace addlabel(file,`name', nbpsn, `nb_psn', nbappln,`nb_oappln', mean_depvar, `mean_depvar') table(E_`name') cmdline

end




cap program drop run_reg_stacked
program define run_reg_stacked
syntax, percentile(real) estimator(string) version(string) window(string)
//options for estimator are "ols", "olswgt","olsb" (OLS with clogit condition),"poisson","clogit"
//options for version are "bline","stratpat","stratpsn","onlyea","placebo"
//options for window are "none", "5yw", "3yw", "nr" (nearest)

global estimator `estimator'
global reg 
global regopt
global cond  "o_no_coord_info == 0 & d_no_coord_info == 0"

global wgt 
if "`estimator'" == "ols" {
	global reg reghdfe
	global regopt cl(gp)
}
if "`estimator'" == "olswgt" {
	global reg reghdfe
	global regopt cl(gp)
	global wgt [aw = invN]
}
if "`estimator'" == "olsb" {
	global reg reghdfe
	global regopt cl(gp)
	global cond $cond & both_AA_and_EA==1 & nb_obs < 100
}
if "`estimator'" == "poisson" {
	global reg ppmlhdfe
	global regopt eform cl(gp)
}
if "`estimator'" == "clogit" {
	global reg clogit
	global regopt "difficult or iterate(20) cluster(gp) group(gp)"
	global cond $cond & both_AA_and_EA==1 & nb_obs < 100
}
global condopen
global w
if "`window'" == "5yw" {
	global condopen if timetotreat <= 5
	global w `window'
}
if "`window'" == "3yw" {
	global condopen if timetotreat <= 3
	global w `window'
}
if "`window'" == "nr" {
	global condopen
	global w `window'
}

use $condopen using  "$HDdata/MicroTest/ODapp_RegReadyNetwork_CSP`percentile'_Stacked", clear

if "`window'" == "nr" {
	bys o_appln_id d_appln_id: gegen min_ttt = min(timetotreat)
	keep if timetotreat == min_ttt
}

// sets of control variables to introduce
global AC_CV "psn_AC_AA psn_AC AC_AA AC_bef fam_AC"
global AC_CV_ME "psn_AC_AA_ME psn_AC_ME fam_AC_ME AC_AA AC_bef"
global AC_CV_Interacted "${AC_CV} psn_AC_AA_and_psn_CBC_AA psn_AC_and_psn_CBC_AA AC_AA_and_psn_CBC_AA AC_and_psn_CBC_AA fam_AC_and_psn_CBC_AA"
global AC_CV_Placebo "${AC_CV} psn_AC_EA AC_EA"
global other_CV "ln_age ln_quality ln_tech_dist ln_m_distance"
global other_CV_nodist "ln_age ln_quality ln_tech_dist"
global VI_basic "C_AA CBC_AA"
global VI "C_AA CBC_AA CBC_bef"
global VI_Interacted "${VI} C_AA_and_psn_CBC_AA CBC_AA_and_psn_CBC_AA CBC_bef_and_psn_CBC_AA"
global VI_ME "C_AA_ME CBC_AA_ME CBC_ME psn_CBC_AA_ME psn_CBC_ME"
global VI_Placebo "${VI} C_EA CBC_EA psn_CBC_EA"


if regexm("`version'", "strat") {
	*** Define strategic citations as ones already cited by applicant and then cited by examiner but not by examiner
	gen stratpat = (EA == 1 & AA == 0 & AC_AA == 1)
	gen stratpsn = (EA == 1 & AA == 0 & psn_AC_AA == 1)
	replace AA = 1 if `version' == 1
	****
	}
if "`version'"	== "onlyea" {
	keep if EA == 1
	}


if "`version'" == "placebo" {
	global VI $VI_Placebo
	global AC_CV $AC_CV_Placebo
}
if "$estimator" == "clogit" {
	bys o_appln_id: gegen has_AA = max(AA)
	bys o_appln_id: gegen has_EA = min(AA)
	replace has_EA = 1 - has_EA
	gen both_AA_and_EA = has_AA * has_EA
	drop has_AA has_EA
}

keep if (${cond})

if `percentile' != 99 {
	local version p`percentile'
}


keep o_appln_id d_appln_id gp mod_?_psn AA $VI $AC_CV  $other_CV
if "`estimator'" == "olswgt" {
	bys o_appln_id d_appln_id: gen invN = 1 / _N
}


if inlist("$reg","reghdfe") {

	$reg  AA $VI $AC_CV $wgt, absorb(gp) $regopt
	estimate_regsave, name(stacked_${estimator}_sp1_`version'${w}) 

	$reg  AA $VI $AC_CV $wgt, absorb(gp mod_d_psn) $regopt
	estimate_regsave, name(stacked_${estimator}_sp1psn_`version'${w}) 

	$reg  AA $VI $AC_CV $other_CV $wgt, absorb(gp) $regopt 
	estimate_regsave, name(stacked_${estimator}_sp2_`version'${w}) 

	$reg  AA $VI $AC_CV $other_CV $wgt, absorb(gp mod_d_psn) $regopt
	estimate_regsave, name(stacked_${estimator}_sp2psn_`version'${w}) 

	if "`version'"== "bline" & `percentile' == 99 & "$estimator" == "ols" & "`window'" == "none" {
			
		$reg  AA $VI $wgt, absorb(gp d_appln_id) $regopt
		estimate_regsave, name(stacked_${estimator}_sp0appln_`version'${w}) 

		$reg  AA $VI $AC_CV $wgt, absorb(gp d_appln_id) $regopt
		estimate_regsave, name(stacked_${estimator}_sp1appln_`version'${w}) 

		$reg  AA $VI $AC_CV $other_CV $wgt, absorb(gp d_appln_id) $regopt
		estimate_regsave, name(stacked_${estimator}_sp2appln_`version'${w}) 

	}
}
	
else {

	$reg  AA $VI, $regopt
	estimate_regsave, name(stacked_${estimator}_sp0_`version'${w}) 

	$reg  AA $VI $AC_CV, $regopt
	estimate_regsave, name(stacked_${estimator}_sp1_`version'${w}) 

	$reg  AA $VI $AC_CV $other_CV, $regopt
	estimate_regsave, name(stacked_${estimator}_sp2_`version'${w}) 
}	

end

	