
cap program drop build_reg_file_stacked
program define build_reg_file_stacked
syntax, start(integer) end(integer) percentile(real) 


foreach type in o d {
	local Type = upper("`type'")
	clear
	forvalues ystart = `start'/`end' {
		append using "$HDdata/MicroTest/ODapp_RegReadyNetwork_CSP`percentile'_IY`ystart'", keep(`type'_appln_id)
	}
	ren `type'_appln_id appln_id
	gduplicates drop
	merge 1:m appln_id using "$HDsources/Applications/AppPsnID_OnlyAssignee", nogen keep(3)
	bys appln_id: egen nb = nvals(psn_id)
	gen rdm = uniform()
	drop if mi(nb)
	bys appln_id (nb rdm): egen mod_`type'_psn = max(psn_id * (_n == _N))
	drop nb rdm
	keep appln_id mod_`type'_psn
	gduplicates drop
	save "$HDdata/MicroTest/`Type'app`Type'psn_forReg", replace
	}

clear
gen cohort = .
forvalues ystart = `start'/`end' {
	append using "$HDdata/MicroTest/ODapp_RegReadyNetwork_CSP`percentile'_IY`ystart'"
	replace cohort = `ystart' if mi(cohort)
}
bys o_appln_id cohort: gen nb_obs = _N

desc using "$HDdata/MicroTest/ODapp_Network_CSP`percentile'_IY2000.dta", varlist
dis "`r(varlist)'"
foreach var in `r(varlist)' {
	cap replace `var' = 0 if mi(`var')
}
ren o_appln_id appln_id
merge m:1 appln_id using "$HDdata/MicroTest/OappOpsn_forReg", gen(_mOpsn) keep(1 3)
ren appln_id o_appln_id 
ren d_appln_id appln_id
merge m:1 appln_id using "$HDdata/MicroTest/DappDpsn_forReg", gen(_mDpsn) keep(1 3)
ren appln_id d_appln_id 


ren o_appln_id appln_id
merge m:1 appln_id using "$HDsources/Dates/App_Dates.dta", nogen keep(3) keepusing(priority_date)
gen o_year = year(priority_date)
ren appln_id o_appln_id 


reg AA C_AA CBC_AA
keep if e(sample)


gen timetotreat = o_year - cohort
replace timetotreat = 15 if timetotreat > 15 & !mi(timetotreat)

egen double gp = group(o_appln_id cohort)
compress
save "$HDdata/MicroTest/ODapp_RegReadyNetwork_CSP`percentile'_Stacked", replace

end

