
	
**----------------		

global lab_ln_age "(ln) Age difference"
global lab_ln_m_distance "(ln) Geo. distance"
global lab_ln_quality "(ln) Quality difference"
global lab_ln_tech_dist "(ln) Tech. distance"

use "$HDdata/MicroTest/ODapp_RegReadyNetwork_CSP99_Stacked", clear
gen rdm = runiform()
*keep if rdm < .01
colorpalette tableau, n(2) nograph
global color1 `r(p1)'
global color2 `r(p2)'
foreach var in ln_age ln_m_distance ln_quality ln_tech_dist {
	su `var' if AA == 1, d
	local mean1 = `r(mean)'
	local p251 = `r(p25)'
	local p751 = `r(p75)'
	su `var' if AA == 0, d
	local mean0 = `r(mean)'
	local p250 = `r(p25)'
	local p750 = `r(p75)'
	tw (kdensity `var' if AA == 1, lcolor("$color1")) (kdensity `var' if AA == 0, lcolor("$color2")), xline(`mean1', lcolor("$color1") lpattern(solid)) xline(`mean0', lcolor("$color2") lpattern(solid)) xline(`p251', lcolor("$color1%25") lpattern(--)) xline(`p250', lcolor("$color2%25") lpattern(--))  xline(`p751', lcolor("$color1%25") lpattern(--)) xline(`p750', lcolor("$color2%25") lpattern(--)) legend(pos(6) row(1) order(1 "AA" 2 "EA") size(medlarge)) xtitle("${lab_`var'}", size(large)) ytitle(Density, size(large))
	graph export "$figures/kdensity_`var'.pdf", as(pdf) replace
}
colorpalette tableau, n(2) nograph
global color1 `r(p1)'
global color2 `r(p2)'
foreach var in ln_age ln_m_distance ln_quality ln_tech_dist {
	su `var' if AA == 1, d
	local mean1 = `r(mean)'
	local p251 = `r(p25)'
	local p751 = `r(p75)'
	su `var' if AA == 0, d
	local mean0 = `r(mean)'
	local p250 = `r(p25)'
	local p750 = `r(p75)'
	tw (kdensity `var' if AA == 1, lcolor("$color1")) (kdensity `var' if AA == 0, lcolor("$color2")), xline(`mean1', lcolor("$color1") lpattern(solid)) xline(`mean0', lcolor("$color2") lpattern(solid)) xline(`p251', lcolor("$color1%25") lpattern(--)) xline(`p250', lcolor("$color2%25") lpattern(--))  xline(`p751', lcolor("$color1%25") lpattern(--)) xline(`p750', lcolor("$color2%25") lpattern(--)) legend(pos(6) row(1) order(1 "AA" 2 "EA") size(medlarge)) xtitle("${lab_`var'}", size(large)) ytitle(Density, size(large))
	graph export "$figures/kdensity_`var'.pdf", as(pdf) replace
}

