cd "${results}/MicroTest/"


**----------------------------
** Build Table 2 in draft
**----------------------------

local samp bline
global w

use stacked_ols_sp1_`samp'${w}, clear
merge 1:1 var using stacked_ols_sp2_`samp'${w}, nogen
merge 1:1 var using stacked_ols_sp1psn_`samp'${w}, nogen
merge 1:1 var using stacked_ols_sp2psn_`samp'${w}, nogen



if "`samp'" == "placebo" {
	drop if regexm(var,"AA")
	replace var = subinstr(var,"C_EA","C_AA",.)
}

drop if var == "cmdline" | var == "file"
destring E*, replace


keep if regexm(substr(var,1,4),"C_AA") | regexm(substr(var,1,6),"CBC_AA") |  regexm(var,"mean_depvar") | inlist(var,"N","r2","nbappln","nbpsn")

format E* %12.3g
br
drop if var == "r2"
gen order = 1 if var == "C_AA_coef"
replace order = 2 if var == "C_AA_stderr"
replace order = 3 if var == "CBC_AA_coef"
replace order = 4 if var == "CBC_AA_stderr"
replace order = 96 if var == "mean_depvar"
replace order = 97 if var == "nbpsn"
replace order = 98 if var == "nbappln"
replace order = 99 if var == "N"
sort order

foreach var of varlist E* {
	replace `var' = `var' /1e6  if var == "N" | var == "nbappln"
	replace `var' = `var' /1e3  if var == "nbpsn"
}


tostring E*, replace
foreach var of varlist E* {
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"coef")
	replace `var' = `var' + "0" if regexm(var,"coef") & length(`var') == 3
	replace `var' = `var' + "$^{***}$" if regexm(var,"coef")
	replace `var' = string(round(real(`var'),0.0001)) if regexm(var,"stderr")
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"mean_depvar")
	replace `var' = string(round(real(`var'),0.1)) if var == "N" | var == "nbappln" | var == "nbpsn"
	replace `var' = `var' + "M" if var == "N" | var == "nbappln"
	replace `var' = `var' + "k" if var == "nbpsn"
	replace `var' = "0" + `var' if substr(`var',1,1) == "."
	replace `var' = "-0" + substr(`var',2,.) if substr(`var',1,2) == "-."
	replace `var' = "(" + `var' + ")" if regexm(var,"stderr")
}


gen labvar = ""
replace labvar = "\textcolor{mydkred1}{\textbf{Source}} " if var == "C_AA_coef" 
replace labvar = "\addlinespace \textcolor{mydkblue1}{\textbf{Cited by Source}}" if var == "CBC_AA_coef" 
replace labvar = "\addlinespace \cmidrule(r){2-5} Mean of the dep. variable" if var == "mean_depvar" 
replace labvar = "Number of citing firms" if var == "nbpsn" 
replace labvar = "Number of citing patents" if var == "nbappln"
replace labvar = "Number of observations" if var == "N" 

drop order var
order labvar 

listtab using "$tables/regtable_`samp'${w}.tex", replace type rstyle(tabular) head("\begin{tabular}{l cccc} \toprule"  `" \multicolumn{4}{l}{\textbf{Dep. var.: Patent cited by the applicant}} \\ \midrule"' `" &  &  & & Baseline \\[.2em]"' `" & (1) & (2) & (3) & (4) \\"' `"\cmidrule(l){2-4} \cmidrule(lr){5-5} "') ///
	foot(`"\addlinespace  \cmidrule(r){2-5} Citing patent FE & \checkmark & \checkmark & \checkmark & \checkmark \\"' ///
	`"Cited firm FE & -- & -- & \checkmark & \checkmark \\"' ///
	`"Pairwise controls & -- & \checkmark & -- & \checkmark  \\"' ///
	`"Past citations controls & \checkmark  & \checkmark & \checkmark & \checkmark \\"' ///
	"\bottomrule \end{tabular}")

**_____________



**----------------------------
** Build Table 3 in draft
**----------------------------

use stacked_ols_sp2psn_bline, clear
merge 1:1 var using stacked_ols_sp2psn_onlyea, nogen
merge 1:1 var using stacked_ols_sp2psn_stratpat, nogen
merge 1:1 var using stacked_ols_sp2psn_stratpsn, nogen
replace var = subinstr(var,"AA:","",.)


if "`samp'" == "placebo" {
	drop if regexm(var,"AA")
	replace var = subinstr(var,"C_EA","C_AA",.)
}

drop if var == "cmdline" | var == "file"
destring E*, replace force


keep if regexm(substr(var,1,4),"C_AA") | regexm(substr(var,1,6),"CBC_AA") |  regexm(var,"mean_depvar") | inlist(var,"N","r2","nbappln","nbpsn")

format E* %12.3g
br
drop if var == "r2"
gen order = 1 if var == "C_AA_coef"
replace order = 2 if var == "C_AA_stderr"
replace order = 3 if var == "CBC_AA_coef"
replace order = 4 if var == "CBC_AA_stderr"
replace order = 96 if var == "mean_depvar"
replace order = 97 if var == "nbpsn"
replace order = 98 if var == "nbappln"
replace order = 99 if var == "N"
sort order

foreach var of varlist E* {
	replace `var' = `var' /1e6  if var == "N" | var == "nbappln"
	replace `var' = `var' /1e3  if var == "nbpsn"
}


tostring E*, replace force
foreach var of varlist E* {
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"coef")
	replace `var' = `var' + "0" if regexm(var,"coef") & length(`var') == 3
	replace `var' = `var' + "$^{***}$" if regexm(var,"coef")
	replace `var' = string(round(real(`var'),0.0001)) if regexm(var,"stderr")
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"mean_depvar")
	replace `var' = string(round(real(`var'),0.1)) if var == "N" | var == "nbappln" | var == "nbpsn"
	replace `var' = `var' + "M" if var == "N" | var == "nbappln"
	replace `var' = `var' + "k" if var == "nbpsn"
	replace `var' = "0" + `var' if substr(`var',1,1) == "."
	replace `var' = "-0" + substr(`var',2,.) if substr(`var',1,2) == "-."
	replace `var' = "(" + `var' + ")" if regexm(var,"stderr")
}


gen labvar = ""
replace labvar = "\textcolor{mydkred1}{\textbf{Source}} " if var == "C_AA_coef" 
replace labvar = "\addlinespace \textcolor{mydkblue1}{\textbf{Cited by Source}}" if var == "CBC_AA_coef" 
replace labvar = "\addlinespace \cmidrule(r){2-5} Mean of the dep. variable" if var == "mean_depvar" 
replace labvar = "Number of citing firms" if var == "nbpsn" 
replace labvar = "Number of citing patents" if var == "nbappln"
replace labvar = "Number of observations" if var == "N" 

drop order var
order labvar 
*\multirow{2}{*}{
listtab using "$tables/regtable_robustness_prefspec.tex", replace type rstyle(tabular) head("\begin{tabular}{l cccc} \toprule"  `" \multicolumn{4}{l}{\textbf{Dep. var.: Patent cited by the applicant}} \\ \midrule"' `" & \multirow{2}{*}{Baseline} & \multirow{2}{*}{\shortstack[c]{Examiner \\ overlap}} & \multicolumn{2}{c}{Strategic} \\"' `" &  &  & Pat. lev. & Firm lev. \\"' `" & (1) & (2) & (3) & (4) \\[.2em]"' `"\cmidrule(l){2-2} \cmidrule(l){3-3} \cmidrule(l){4-5}"') ///
	foot(`"\addlinespace  \cmidrule(r){2-5} Citing patent FE &  \checkmark  & \checkmark & \checkmark & \checkmark \\"' ///
	`"Cited applicant FE & \checkmark & \checkmark & \checkmark & \checkmark \\"' ///
	`"Pairwise controls & \checkmark & \checkmark & \checkmark & \checkmark \\"' ///
	`"Past citations controls & \checkmark & \checkmark  & \checkmark & \checkmark \\"' ///
	"\bottomrule \end{tabular}")
	
**_____________


**----------------------------
** Build Table B1 in draft
**----------------------------

estimates clear

use "$HDdata/MicroTest/ODapp_RegReadyNetwork_CSP99_Stacked", clear
global AC_CV "psn_AC_AA psn_AC AC_AA AC_bef fam_AC"
global other_CV "ln_age ln_quality ln_tech_dist ln_m_distance"
global VI "C_AA CBC_AA CBC_bef" 
cap ren AC AC_bef

bys AA: egen nboappln = nvals(o_appln_id)
bys AA: egen nbopsn = nvals(mod_o_psn)

format nb* %15.0f

su $VI $AC_CV $other_CV

*tabstat  $VI $AC_CV $other_CV, s(mean p50 p10 p90) by(AA) c(s) nototal

label var C_AA "\textcolor{mydkred1}{\textbf{Source}}"
label var CBC_AA "\textcolor{mydkblue1}{\textbf{Cited by Source}}"
label var C_EA "\textcolor{mydkred1}{\textbf{Fake Contact}}"
label var CBC_EA "\textcolor{mydkblue1}{\textbf{Falsely Cited by Contact}}"
label var CBC_bef "Cited by Contact before initialization year"
label var psn_AC_AA "Firm already cited by applicant"
label var psn_AC "Firm already cited"
label var AC_AA "Patent already cited by applicant"
label var AC_bef "Already cited before initialization year"
label var fam_AC "Patent family already cited"
label var ln_age "Ln(Age Diff.)"
label var ln_quality "Ln(Quality Diff.)"
label var ln_tech_dist "Ln(Tech. Dist. )"
label var ln_m_distance "Ln(Geo. Dist.)"
label var nbopsn "Nb. of citing firms"
label var nboappln "Nb. of citing patents"

estpost sum $VI $AC_CV $other_CV nbopsn nboappln if AA == 1, d
est store a

estpost sum $VI $AC_CV $other_CV nbopsn nboappln if AA == 0, d
est store b

esttab a b using "$tables/statsdesc_estimationsample.tex", replace cells("mean(fmt(%8.3f)) sd(fmt(%8.3f)) p10(fmt(%8.3f)) p90(fmt(%8.3f))") booktabs nonum label mgroups("Applicant-added citations" "Examiner-added citations", pattern(1 1) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span}))


**_____________



**----------------------------
** Build Table B2 in draft
**----------------------------

use stacked_ols_sp2psn_bline, clear
merge 1:1 var using stacked_ols_sp2psn_p999, nogen
merge 1:1 var using stacked_ols_sp2psn_p9999, nogen
merge 1:1 var using stacked_ols_sp2psn_bline3yw, nogen
merge 1:1 var using stacked_ols_sp2psn_bline5yw, nogen
merge 1:1 var using stacked_ols_sp2psn_blinenr, nogen
merge 1:1 var using stacked_ols_sp1appln_bline, nogen
merge 1:1 var using stacked_ols_sp2appln_bline, nogen
replace var = subinstr(var,"AA:","",.)


if "`samp'" == "placebo" {
	drop if regexm(var,"AA")
	replace var = subinstr(var,"C_EA","C_AA",.)
}

drop if var == "cmdline" | var == "file"
destring E*, replace force


keep if regexm(substr(var,1,4),"C_AA") | regexm(substr(var,1,6),"CBC_AA") |  regexm(var,"mean_depvar") | inlist(var,"N","r2","nbappln","nbpsn")

format E* %12.3g
br
drop if var == "r2"
gen order = 1 if var == "C_AA_coef"
replace order = 2 if var == "C_AA_stderr"
replace order = 3 if var == "CBC_AA_coef"
replace order = 4 if var == "CBC_AA_stderr"
replace order = 96 if var == "mean_depvar"
replace order = 97 if var == "nbpsn"
replace order = 98 if var == "nbappln"
replace order = 99 if var == "N"
sort order

foreach var of varlist E* {
	replace `var' = `var' /1e6  if var == "N" | var == "nbappln"
	replace `var' = `var' /1e3  if var == "nbpsn"
}


tostring E*, replace force
foreach var of varlist E* {
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"coef")
	replace `var' = `var' + "0" if regexm(var,"coef") & length(`var') == 3
	replace `var' = `var' + "$^{***}$" if regexm(var,"coef")
	replace `var' = string(round(real(`var'),0.0001)) if regexm(var,"stderr")
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"mean_depvar")
	replace `var' = string(round(real(`var'),0.1)) if var == "N" | var == "nbappln" | var == "nbpsn"
	replace `var' = `var' + "M" if var == "N" | var == "nbappln"
	replace `var' = `var' + "k" if var == "nbpsn"
	replace `var' = "0" + `var' if substr(`var',1,1) == "."
	replace `var' = "-0" + substr(`var',2,.) if substr(`var',1,2) == "-."
	replace `var' = "(" + `var' + ")" if regexm(var,"stderr")
}


gen labvar = ""
replace labvar = "\textcolor{mydkred1}{\textbf{Source}} " if var == "C_AA_coef" 
replace labvar = "\addlinespace \textcolor{mydkblue1}{\textbf{Cited by Source}}" if var == "CBC_AA_coef" 
replace labvar = "\addlinespace \cmidrule(r){2-9} Mean of the dep. variable" if var == "mean_depvar" 
replace labvar = "Number of citing firms" if var == "nbpsn" 
replace labvar = "Number of citing patents" if var == "nbappln"
replace labvar = "Number of observations" if var == "N" 

drop order var
order labvar 
listtab using "$tables/regtable_robustness_2.tex", replace type rstyle(tabular) head("\begin{tabular}{l c cc ccc cc} \toprule"  `" \multicolumn{7}{l}{\textbf{Dep. var.: Patent cited by the applicant}} \\ \midrule"' `" & \multirow{2}{*}{Baseline} & \multicolumn{2}{c}{Contact size} & \multicolumn{3}{c}{Time window} & \multicolumn{2}{c}{\multirow{2}{*}{\shortstack[c]{Cited \\ patent FE}}} \\"' `" &  &  $\leq$ p99.9 &  $\leq$ p99.99 & $[i;i+3]$  & $[i;i+5]$ & $\min_{n} i+n$ & & \\"' `" & (1) & (2) & (3) & (4)  & (5) & (6) & (7) & (8) \\"' `"\cmidrule(l){2-2} \cmidrule(l){3-4} \cmidrule(l){5-7}  \cmidrule(l){8-9}"') ///
	foot(`"\addlinespace  \cmidrule(r){2-9} Citing patent FE &  \checkmark  & \checkmark & \checkmark & \checkmark & \checkmark & \checkmark & \checkmark & \checkmark \\"' ///
	`"Cited applicant FE & \checkmark & \checkmark & \checkmark & \checkmark & \checkmark & \checkmark & -- & -- \\"' ///
	`"Cited patent FE & -- & -- & -- & -- & -- & -- & \checkmark & \checkmark  \\"' ///
	`"Pairwise controls & \checkmark & \checkmark & \checkmark & \checkmark  & \checkmark  & \checkmark  & --  & \checkmark \\"' ///
	`"Past citations controls & \checkmark & \checkmark  & \checkmark & \checkmark  & \checkmark  & \checkmark  & \checkmark & \checkmark \\"' ///
	"\bottomrule \end{tabular}")
	
**_____________	



**----------------------------
** Build Table B3 in draft
**----------------------------


use stacked_clogit_sp0_bline, clear
merge 1:1 var using stacked_clogit_sp1_bline, nogen
merge 1:1 var using stacked_clogit_sp2_bline, nogen
replace var = subinstr(var,"AA:","",.)


if "`samp'" == "placebo" {
	drop if regexm(var,"AA")
	replace var = subinstr(var,"C_EA","C_AA",.)
}

drop if var == "cmdline" | var == "file"
destring E*, replace force


keep if regexm(substr(var,1,4),"C_AA") | regexm(substr(var,1,6),"CBC_AA") |  regexm(var,"mean_depvar") | inlist(var,"N","r2","nbappln","nbpsn")

format E* %12.3g
br
drop if var == "r2"
gen order = 1 if var == "C_AA_coef"
replace order = 2 if var == "C_AA_stderr"
replace order = 3 if var == "CBC_AA_coef"
replace order = 4 if var == "CBC_AA_stderr"
replace order = 96 if var == "mean_depvar"
replace order = 97 if var == "nbpsn"
replace order = 98 if var == "nbappln"
replace order = 99 if var == "N"
sort order

foreach var of varlist E* {
	replace `var' = exp(`var') if regexm(var,"coef")
	replace `var' = `var' /1e6  if var == "N" | var == "nbappln"
	replace `var' = `var' /1e3  if var == "nbpsn"
}


tostring E*, replace force
foreach var of varlist E* {
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"coef")
	replace `var' = `var' + "0" if regexm(var,"coef") & length(`var') == 3
	replace `var' = `var' + "$^{***}$" if regexm(var,"coef")
	replace `var' = string(round(real(`var'),0.0001)) if regexm(var,"stderr")
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"mean_depvar")
	replace `var' = string(round(real(`var'),0.1)) if var == "N" | var == "nbappln" | var == "nbpsn"
	replace `var' = `var' + "M" if var == "N" | var == "nbappln"
	replace `var' = `var' + "k" if var == "nbpsn"
	replace `var' = "0" + `var' if substr(`var',1,1) == "."
	replace `var' = "-0" + substr(`var',2,.) if substr(`var',1,2) == "-."
	replace `var' = "(" + `var' + ")" if regexm(var,"stderr")
}


gen labvar = ""
replace labvar = "\textcolor{mydkred1}{\textbf{Source}} " if var == "C_AA_coef" 
replace labvar = "\addlinespace \textcolor{mydkblue1}{\textbf{Cited by Source}}" if var == "CBC_AA_coef" 
replace labvar = "\addlinespace \cmidrule(r){2-4} Mean of the dep. variable" if var == "mean_depvar" 
replace labvar = "Number of citing firms" if var == "nbpsn" 
replace labvar = "Number of citing patents" if var == "nbappln"
replace labvar = "Number of observations" if var == "N" 

drop order var
order labvar 

listtab using "$tables/regtable_bline_clogit.tex", replace type rstyle(tabular) head("\begin{tabular}{l ccc} \toprule"  `" \multicolumn{4}{l}{\textbf{Dep. var.: Patent cited by the applicant}} \\ \midrule"' `" & (1) & (2) & (3) \\"' `"\cmidrule(l){2-4} "') ///
	foot(`"\addlinespace  \cmidrule(r){2-4} Citing patent FE &  \checkmark  & \checkmark & \checkmark \\"' ///
	`"Pairwise controls & -- &  -- & \checkmark  \\"' ///
	`"Past citations controls & -- & \checkmark  & \checkmark \\"' ///
	"\bottomrule \end{tabular}")
	

	****************************

**----------------------------
** Build Table B4 in draft
**----------------------------
	
	
local samp bline
global w

use stacked_olswgt_sp1_`samp'${w}, clear
merge 1:1 var using stacked_olswgt_sp2_`samp'${w}, nogen
merge 1:1 var using stacked_olswgt_sp1psn_`samp'${w}, nogen
merge 1:1 var using stacked_olswgt_sp2psn_`samp'${w}, nogen



if "`samp'" == "placebo" {
	drop if regexm(var,"AA")
	replace var = subinstr(var,"C_EA","C_AA",.)
}

drop if var == "cmdline" | var == "file"
destring E*, replace


keep if regexm(substr(var,1,4),"C_AA") | regexm(substr(var,1,6),"CBC_AA") |  regexm(var,"mean_depvar") | inlist(var,"N","r2","nbappln","nbpsn")

format E* %12.3g
br
drop if var == "r2"
gen order = 1 if var == "C_AA_coef"
replace order = 2 if var == "C_AA_stderr"
replace order = 3 if var == "CBC_AA_coef"
replace order = 4 if var == "CBC_AA_stderr"
replace order = 96 if var == "mean_depvar"
replace order = 97 if var == "nbpsn"
replace order = 98 if var == "nbappln"
replace order = 99 if var == "N"
sort order

foreach var of varlist E* {
	replace `var' = `var' /1e6  if var == "N" | var == "nbappln"
	replace `var' = `var' /1e3  if var == "nbpsn"
}


tostring E*, replace
foreach var of varlist E* {
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"coef")
	replace `var' = `var' + "0" if regexm(var,"coef") & length(`var') == 3
	replace `var' = `var' + "$^{***}$" if regexm(var,"coef")
	replace `var' = string(round(real(`var'),0.0001)) if regexm(var,"stderr")
	replace `var' = string(round(real(`var'),0.001)) if regexm(var,"mean_depvar")
	replace `var' = string(round(real(`var'),0.1)) if var == "N" | var == "nbappln" | var == "nbpsn"
	replace `var' = `var' + "M" if var == "N" | var == "nbappln"
	replace `var' = `var' + "k" if var == "nbpsn"
	replace `var' = "0" + `var' if substr(`var',1,1) == "."
	replace `var' = "-0" + substr(`var',2,.) if substr(`var',1,2) == "-."
	replace `var' = "(" + `var' + ")" if regexm(var,"stderr")
}


gen labvar = ""
replace labvar = "\textcolor{mydkred1}{\textbf{Source}} " if var == "C_AA_coef" 
replace labvar = "\addlinespace \textcolor{mydkblue1}{\textbf{Cited by Source}}" if var == "CBC_AA_coef" 
replace labvar = "\addlinespace \cmidrule(r){2-5} Mean of the dep. variable" if var == "mean_depvar" 
replace labvar = "Number of citing firms" if var == "nbpsn" 
replace labvar = "Number of citing patents" if var == "nbappln"
replace labvar = "Number of observations" if var == "N" 

drop order var
order labvar 

listtab using "$tables/regtable_olswgt${w}.tex", replace type rstyle(tabular) head("\begin{tabular}{l cccc} \toprule"  `" \multicolumn{4}{l}{\textbf{Dep. var.: Patent cited by the applicant}} \\ \midrule"' `" &  &  & & Baseline \\[.2em]"' `" & (1) & (2) & (3) & (4) \\"' `"\cmidrule(l){2-4} \cmidrule(lr){5-5} "') ///
	foot(`"\addlinespace  \cmidrule(r){2-5} Citing patent FE & \checkmark & \checkmark & \checkmark & \checkmark \\"' ///
	`"Cited firm FE & -- & -- & \checkmark & \checkmark \\"' ///
	`"Pairwise controls & -- & \checkmark & -- & \checkmark  \\"' ///
	`"Past citations controls & \checkmark  & \checkmark & \checkmark & \checkmark \\"' ///
	"\bottomrule \end{tabular}")
