
/*--------------------------------------
This dofile calls programs from:
 - "__ProgramBuildStackedReg" to build the main regression file
 - "__ProgramRunStackedReg" to run the regressions
 
 The output is a set of estimation results which can be used to build TeX tables.
--------------------------------------*/

cap mkdir "${results}/MicroTest"

**-- Build reg file for cohorts 2000 to 2015, max size percentile = 99, to run different versions of the test
build_reg_file_stacked, start(2000) end(2015) percentile(99)

foreach e in ols /* olsb */ /* clogit */  {
	foreach v in /* bline stratpsn stratpat placebo */ onlyea {
	run_reg_stacked, percentile(99) estimator(`e') version(`v') window(none)
	}	
}

**-- Run conditional logit regression on baseline case
run_reg_stacked, percentile(99) estimator(clogit) version(bline) window(none)


**-- Build reg file and run reg with a different max size percentile to be considered a source
foreach p in /* 90 */ /* 999 */ 9999 {
	build_reg_file_stacked, start(2000) end(2015) percentile(`p')
	run_reg_stacked, percentile(`p') estimator(ols) version(bline) window(none)
	}

**-- Run reg limiting citations to a given window around link formation
foreach w in 5yw 3yw nr {
	run_reg_stacked, percentile(99) estimator(ols) version(bline) window(`w')
}

**-- Weight regression such that each citation has the same weight
run_reg_stacked, percentile(99) estimator(olswgt) version(bline) window(none)
