
*PSE server
cap cd "U:"
if regexm("`c(username)'", "a.guillouzouic") == 1 & regexm("`c(pwd)'", "U:")  {
	global RootPath "U:/PercolationReplication"		
	global RootPathR "U:\\PercolationReplication"		
	global sources "M:\Patstat22"
	global HDsources "M:\Patstat22" //should replace HDsources by sources if some remain
	}

* Personal computer (Arthur)
if regexm("`c(username)'", "a.guillouzouic") == 1 & !regexm("`c(pwd)'", "U:") {
	global RootPath "D:/GoogleDrive/PhD/ks_distance"
	global RootPathR "D:\\GoogleDrive\\PhD\\ks_distance"	
	global sources "E:/Sources"
	global HDsources "$HardDrivePath:/Sources"
	}
	

global data "${RootPath}/Data"
global dataR "${RootPathR}\\Data"
global tex "${RootPath}/Tex"
global tables "$tex/Tab"
global figures "$tex/Graphs"
global do "${RootPath}/Code"
global doR "${RootPathR}\\Code"
global results "${RootPath}/Results"
global HDdata $data
global NAMDIR $do/HarmoName
global citations $HDsources/Citations
global geo $HDsources/Geography
global persons $HDsources/Persons
global applications $HDsources/Applications
global ipc $HDsources/IPC
global dates $HDsources/Dates	

cap mkdir "$data"
cap mkdir "$tex"
cap mkdir "$do"
cap mkdir "$figures"
cap mkdir "$tables"
cap mkdir "$results"

global install_packages 0

*cd $do

set seed 29052020
global sampling 33 //this global macro will determine the share of the population of patent applicants which is kept for the network diffusion test
global ymin 2000
global ymax 2015

/*___________________________

Install necessary stata packages
____________________________*/

if $install_packages == 1 {
	ssc install distinct, replace
	ssc install carryforward, replace
	ssc install erepost, replace
	ssc install geodist, replace
	ssc install ftools, replace
	ssc install gtools, replace
	ssc install hdfe, replace
	ssc install kountry, replace
	ssc install labutil, replace
	ssc install mahapick, replace
	ssc install outreg2, replace
	ssc install reghdfe, replace
	ssc install ppmlhdfe, replace
	ssc install egenmore, replace
	ssc install ereplace, replace
	net install rscript, from("https://raw.githubusercontent.com/reifjulian/rscript/master") replace
	ssc install listtab, replace
	ssc install regsave, replace
	ssc install estout, replace
	ssc install palettes
	ssc install colrspace
}

/*___________________________

Run dofiles containing useful programs
____________________________*/

do "$do/programs/__Programs.do" //general purpose programs
do "$do/programs/__ProgramsDataMicroCohort.do" //construction of cohort-specific files
do "$do/programs/__ProgramBuildStackedReg.do" //construction of main regression file using cohort-specific ones
do "$do/programs/__ProgramRunStackedReg.do" //construction of main regression file using cohort-specific ones

/*

/*___________________________

Generate cohort-specific files
____________________________*/

do "$do/1_Build_Cohort_Files.do"


